-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.p2 = Citadels.GetPlayer(2)
    
    if not self.loaded then
      self.active = false
      self.timer = 5
      self.armySent = false
    end
    
    self.targetPos = Game:GetEntity("ravine"):GetPosition()
    self.reinforcements:LinkToTarget("reinfTargetActive")
  end
  
  if self.active then
    if not self.armySent then
			SendArmy(self)
		end
    
    td = Timer:GetTimeDiff()
		self.timer = self.timer - td
		
		if self.timer <= 0 then
			ChangeOwner(self)	
		end
  end 
end

function SendArmy(self)
	self.p2:Deselect()
  self.p2:SelectUnitsByName('p0Reinf')
	self.p2:Move(self.targetPos)
  self.armySent = true
end

function ChangeOwner(self)
	self.p2:SelectUnitsByName('p0Reinf')
	self.p2:SetOwnership(0)
	self.reinforcements:TriggerAllTargets()
	self.active = false
end

function OnTrigger(self, source, target)
  if target == "reinfActive" then
	  self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
    self.armySent = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
    ar:Write(self.armySent)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("reinfActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("reinforcements")
end
